function rsr=RstarR(problems,rr)
% This is to find the R* values for CRRA - that is those values for which
% the DM is indifferent. For r less than that they prefer the riskier one
% and for r greater than that the safer one.
x1=problems(:,1);
x2=problems(:,2);
xp=problems(:,3);
y1=problems(:,4);
y2=problems(:,5);
yp=problems(:,6);
np=size(xp,1);
on=ones(np,1);
for pn=1:1:9
    diff=@(r) (CRRA(x1(pn),r)*xp(pn)+CRRA(x2(pn),r)*(1-xp(pn)))-(CRRA(y1(pn),r)*yp(pn)+CRRA(y2(pn),r)*(1-yp(pn)));
    rsr(pn)=fzero(diff,rr);
end
for pn=11:1:19
    diff=@(r) (CRRA(x1(pn),r)*xp(pn)+CRRA(x2(pn),r)*(1-xp(pn)))-(CRRA(y1(pn),r)*yp(pn)+CRRA(y2(pn),r)*(1-yp(pn)));
    rsr(pn)=fzero(diff,rr);
end
for pn=21:1:29
    diff=@(r) (CRRA(x1(pn),r)*xp(pn)+CRRA(x2(pn),r)*(1-xp(pn)))-(CRRA(y1(pn),r)*yp(pn)+CRRA(y2(pn),r)*(1-yp(pn)));
    rsr(pn)=fzero(diff,rr);
end
for pn=31:1:39
    diff=@(r) (CRRA(x1(pn),r)*xp(pn)+CRRA(x2(pn),r)*(1-xp(pn)))-(CRRA(y1(pn),r)*yp(pn)+CRRA(y2(pn),r)*(1-yp(pn)));
    rsr(pn)=fzero(diff,rr);
end
rsr(10)=-10;
rsr(20)=-10;
rsr(30)=-10;
rsr(40)=-10;
end

